
// material item
local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

//
function PANEL:Init( )
	//
	self.LinkedClass = nil;
	
	//
	self.Icon = nil;
	
	// selected
	self.IsSelected = false;

end

// mouse pressed
function PANEL:DoClick( )
	//?
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnClick", self.LinkedClass );
	
	end
	
	//
	surface.PlaySound( "weapons/slam/buttonclick.wav" );
	
end

// perform layout
function PANEL:PerformLayout( )
	// position icon
	if( self.Icon ) then
		self.Icon:SetPos( 0, 0 );
		self.Icon:SetSize( self:GetWide(), self:GetTall() );
	
	end

end

// paint
function PANEL:Paint( )
	// selected?
	if( self.IsSelected ) then
		// draw.
		local color = AppFramework:CopyColor( AppFramework:Theme().colors['selection'] );
		local bgcolor = AppFramework:Theme().colors['border_light'];
		
		// calculate delta
		local delta = math.sin( CurTime() * 8 ) * 15;
		
		// adjust color, clamping to the valid range.
		color.r = math.Clamp( color.r + delta, 0, 255 );
		color.g = math.Clamp( color.g + delta, 0, 255 );
		color.b = math.Clamp( color.b + delta, 0, 255 );
	
		// square border.
		surface.SetDrawColor(
			bgcolor.r,
			bgcolor.g,
			bgcolor.b,
			bgcolor.a
		);
		surface.DrawRect(
			0, 0,
			self:GetWide(), self:GetTall()
		);
		
		
		// square border.
		surface.SetDrawColor(
			color.r,
			color.g,
			color.b,
			color.a
		);
		surface.DrawRect(
			1, 1,
			self:GetWide() - 2, self:GetTall() - 2
		);
	
	end

	//
	return true;
	
end

// set icon
function PANEL:SetIcon( mat )
	// create
	if( !self.Icon ) then
		self.Icon = vgui.Create( "ctl_icon", self );
		self.Icon:SetMouseInputEnabled( false );
		self.Icon:SetAlpha( 128 );
		
	end
	
	// full texture.
	if( type( mat ) == "string" ) then
		self.Icon:SetMaterial( mat );
		
	// imagelist?
	elseif( type( mat ) == "number" && self.ImageList ) then
		local texture = self.ImageList:Get( mat );
		if( texture ) then
			self.Icon.Material = texture;
			
		end
	
	end
	
end

//
function PANEL:SetSelected( v )
	self.IsSelected = v;
	
	// update alpa
	if( self.Icon ) then
		// selected
		if( v ) then
			self.Icon:SetAlpha( 255 );
		
		// unselected
		else
			self.Icon:SetAlpha( 128 );
		
		end
		
	end

end

//
vgui.Register( "ctl_material", PANEL, "Button" );

// create app framework control.
CtlMaterial_class 	= Control_class:create( nil, false, "ctl_material" );

function CtlMaterial_class:SetSelected( v )
	self:GetHandle():SetSelected( v );

end

function CtlMaterial_class:SetIcon( v )
	self:GetHandle():SetIcon( v );

end












//
local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// our materials
	self.Selected = nil;
	self.Children = {};
	
	// scroll
	self.Scroll = 0;
	self.MaterialWidth = 16;
	self.MaterialHeight = 16;
	
	// left/right buttons
	/*self.LeftButton = CtlButton_class:create( self );
	self.LeftButton:SetText( "" );
	
	self.RightButton = CtlButton_class:create( self );
	self.RightButton:SetText( "" );*/
	
	// create the two canvases
	self.PrimaryCanvas = CtlCanvas_class:create( self );
	self.Canvas = CtlCanvas_class:create( self.PrimaryCanvas:GetHandle() );
	
end

//
function PANEL:OnMouseWheeled( delta )
	// scroll
	self.Scroll = math.Clamp( self.Scroll + ( delta * 8 ), -( self.Canvas:GetHandle():GetWide() - self.PrimaryCanvas:GetHandle():GetWide() ), 0 );

	// position
	self:InvalidateLayout();
	
end

// add material
function PANEL:AddMaterial( mat )
	// create
	local material = CtlMaterial_class:create( self.Canvas:GetHandle() );
	material:SetIcon( mat );
	material:SetSize( self.MaterialWidth, self.MaterialHeight );
	material:AddEvent( "OnClick", "OnMaterialSelected", self );
	material.Material = mat;
	
	// add
	table.insert( self.Children, material );

	// invalidate
	self:InvalidateLayout();
	
end

//
function PANEL:OnMaterialSelected( material )
	// have a selected?
	if( self.Selected ) then self.Selected:SetSelected( false ); end
	
	//
	material:SetSelected( true );
	self.Selected = material;

end


// perform layout
function PANEL:PerformLayout( )
	// position left
	/*
	self.LeftButton:SetPos( 1, 1 );
	self.LeftButton:SetSize( 16, self:GetTall() - 2 );
	*/
	
	// position the primary canvas
	self.PrimaryCanvas:SetPos( 4, 4 );
	self.PrimaryCanvas:SetSize( self:GetWide() - 8, self:GetTall() - 8 );
	
	
	// size the materials
	local i;
	local ofs = 0;
	for i = 1, table.getn( self.Children ) do
		// position.
		self.Children[i]:SetPos( ofs, ( ( self:GetTall() - 8 ) * 0.5 ) - ( self.MaterialHeight * 0.5 ) );
		
		//
		ofs = ofs + self.MaterialWidth;
		
	end
	
	// size the canvas
	self.Canvas:SetPos( self.Scroll, 0 );
	self.Canvas:SetSize( ofs, self:GetTall() - 2 );
	
	// position right
	/*
	self.RightButton:SetPos( self:GetWide() - 17, 1 );
	self.RightButton:SetSize( 16, self:GetTall() - 2 );
	*/
	
end

// add material.
function PANEL:SetMaterial( mat )
	// have a selected?
	if( self.Selected ) then self.Selected:SetSelected( false ); end
	self.Selected = nil;
	
	// find the material.
	local i;
	for i = 1, table.getn( self.Children ) do
		if( self.Children[i].Material == mat ) then
			// select.
			self.Selected = self.Children[i];
			self.Selected:SetSelected( true );
			
			//
			break;
		
		end
	
	end
	
end


// draw
function PANEL:Paint( )
	// frame.
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET );
	
	//
	return true;
	
end

//
function PANEL:SetMaterialSize( w, h )
	self.MaterialWidth = w;
	self.MaterialHeight = h;

end

// register
vgui.Register( "ctl_materialselector", PANEL, "Panel" );


// create app framework control.
CtlMaterialSelector_class 	= Control_class:create( nil, false, "ctl_materialselector" );

//
function CtlMaterialSelector_class:AddMaterial( mat )
	self:GetHandle():AddMaterial( mat );

end

//
function CtlMaterialSelector_class:SetMaterialSize( w, h )
	self:GetHandle():SetMaterialSize( w, h );

end

//
function CtlMaterialSelector_class:GetMaterial( )
	return self:GetHandle().Selected;

end

//
function CtlMaterialSelector_class:SetMaterial( mat )
	return self:GetHandle():SetMaterial( mat );

end

//
function CtlMaterialSelector_class:ClearSelection( )
	//
	if( self:GetHandle().Selected ) then
		self:GetHandle().Selected:SetSelected( false );
		self:GetHandle().Selected = nil;
	
	end

end

